
#ifndef _1_CRYS_SEP_ATP_HMAC_Acceptance_h_H
#define _1_CRYS_SEP_ATP_HMAC_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_HASH_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/

/******** Public Variables ********/
/******** Public Functions ********/
/***************************
* Function Name:                                                           
* 	SEPQA_HMAC_NotIntegrated 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CRYSError_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for HMAC non integrated API's							
* 	This function HMAC known vectors using SHA1\SHA224\SHA256\SHA384\SHA512 and MD5
* 	Vector sizes used (in bytes) - 16/32/512/1536									
* Algorithm:	
* 1. Allocate memory buffers
* 2. Call the CRYS_HMAC_Init function to start the encryption/decryption process
* 3. Call the CRYS_HMAC_Update - This function is called N times
*                                (N = number of blocks in data each block is 16byte)
* 4. Call the CRYS_HMAC_Finish to end the HMAC process and get the Digest result
* 5. Compare the outputted result to the expected one													
* 6. Free allocated buffers
*
**************************/
CRYSError_t SEPQA_HMAC_NotIntegrated(CRYS_HASH_OperationMode_t   OperationMode,
									DxUint8_t                  *Key_ptr,
									DxUint16_t                  KeySize,
									DxUint8_t                  *DataIn_ptr,
									DxUint32_t                  DataInSize,
									DxUint8_t                  *ExpectedData_ptr,        
									DxUint32_t                  DataExpSize,
									DxUint8_t                  *FailureFunctionNameOut_ptr);



/***************************
* Function Name:                                                           
* 	SEPQA_HMAC_Integrated 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CRYSError_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for HMAC integrated API's							
* 	This function HMAC known vectors using SHA1\SHA224\SHA256\SHA384\SHA512 and MD5
* 	Vector sizes used (in bytes) - 16/32/512/1536									
* Algorithm:	
* 1. Allocate memory buffers
* 2. Call the CRYS_HMAC function to execute the HMAC process
* 3. Compare the outputted result to the expected one													
* 4. Free allocated buffers
*
**************************/
CRYSError_t SEPQA_HMAC_Integrated(CRYS_HASH_OperationMode_t   OperationMode,
								  DxUint8_t                  *Key_ptr,
								  DxUint16_t                  KeySize,
								  DxUint8_t                  *DataIn_ptr,
								  DxUint32_t                  DataInSize,
								  DxUint8_t                  *ExpectedData_ptr,        
								  DxUint32_t                  DataExpSize,
								  DxUint8_t                  *FailureFunctionNameOut_ptr);
								  



#ifdef __cplusplus
}
#endif

#endif



